
libname q 'C:\SASCodeForBook\SASDataSets';
Data first; set q.adlten;

/*this code will produce the data for Table 8.10*/

Remembrance = 1 - TooMuchShoahTalk; 

Valueslife = (PAProPeace + IsraelProPeace + remembrance)/3;
ValuesJewishLife = (IsraelProPeace + remembrance)/2;
propeace = (PAProPeace + IsraelProPeace)/2;

DislikesIsrael = (IsraelAntiPeace + ViewsIsraelUnfavorably)/2;

cohesion = (ownkind + loyaltoIsrael)/2;
corruption = (shady + toomuchpower)/2;
 
RadicalRight = 0;
If country = 'Belgium' then RadicalRight = 1;
If country = 'Austria' then RadicalRight = 1;
If country = 'France' then RadicalRight = 1;
count = 500;

Reparations = 0;
If country = 'Germany' then Reparations = 1;
If country = 'Austria' then Reparations = 1;
If country = 'Switzerland' then Reparations = 1;
 
AntiPeace = (PAAntiPeace + IsraelAntiPeace)/2;

Belgium = 0;
If country = 'Belgium' then Belgium = 1;

ManyJewsMuslims = 0;
if (jewishbinary = 1 and muslimbinary = 1) then manyjewsmuslims = 1;

Twotreatments = ManyJewsMuslims;

Threetreatments = 0;
If (jewishbinary = 0 and muslimbinary = 0) then threetreatments = 3;
If (jewishbinary = 0 and muslimbinary = 1) then threetreatments = 2;
If (jewishbinary = 1 and muslimbinary = 1) then threetreatments = 1;

Yeardummy = 0;
If year = 2004 then yeardummy = 1;

Fiveyears = 0;
If year = 2001 then Fiveyears = 5;
If year = 2002 then Fiveyears = 4;
If year = 2003 then Fiveyears = 3;
If year = 2004 then Fiveyears = 2;
If year = 2005 then Fiveyears = 1;

Disaffection = (IsraelAntiPeace + PAProPeace + ViewsIsraelUnfavorably + ProPalestine)/4;

fiveitems =(toomuchshoahtalk + ownkind + loyaltoIsrael + shady + toomuchpower)/5;

run;

	/*The values of the Deviance and Scaled Deviance were obtained from the Glimmix Macro*/
	/* Code for Table 8.10, Model 1 that comprises the Intercepts.  Also used in Figure 8.2*/

Title ' Model 1, Baseline Model, Intercept Only';
proc glimmix data = first method = rspl ic=pq ;
	class country ManyJewsMuslims;
	model violence0103 =   / link = log dist = poisson solution;
	random country(manyjewsmuslims )/solution;
	random _residual_ /s; 
	Covtest 'zerog = no G-side' zerog / cl Wald estimates;
run; 

/* Code for Table 8.9, Model 4 that comprises Intercept,Year,Population Type, Belgium, 
	Structural Model.  Also Used in Figure 8.2*/

Title ' this run uses ic = pq for model 4';
proc glimmix data = first ic=pq;
	class country year ManyJewsMuslims Belgium ;
	model violence0103 = year manyjewsmuslims Belgium  
	/ link = log dist = poisson s;
	random country(manyjewsmuslims)/solution;
	random _residual_ /s;
	Covtest 'zerog = no G-side' zerog / cl Wald estimates;
run; 


/* Code for Table 8.9, Model 5 that comprises Intercept,Year,Population Type, Belgium, and
	PAProPeace.  Also used in Figure 8.2*/

Title ' this run uses ic = pq for model 5';
proc glimmix data = first ic=pq;
	class country year ManyJewsMuslims Belgium ;
	model violence0103 = year manyjewsmuslims Belgium PAProPeace / link = log dist = poisson s;
	random country(manyjewsmuslims)/solution;
	random _residual_ /s;
	Covtest 'zerog = no G-side' zerog / cl Wald estimates;
run; 



/* Code for Table 8.9, Model 8 that comprises Intercept,Year,Population Type, Belgium, 
	and Values Jewish Lives.  Also used in Figure 8.2.*/

Title ' this run uses ic = pq for model 8';
proc glimmix data = first ic=pq;
	class country year ManyJewsMuslims Belgium ;
	model violence0103 = year manyjewsmuslims Belgium  ValuesJewishLife 
		/ link = log dist = poisson s;
	random country(manyjewsmuslims)/solution;
	random _residual_ /s;
	Covtest 'zerog = no G-side' zerog / cl Wald estimates;
run; 


/* Code for Table 8.9, Model 9 that comprises Intercept,Year,Population Type, Belgium, 
	Values Jewish and Palestinian Lives.  Also used in Figure 8.2.*/

Title ' this run uses ic = pq for model 9';
proc glimmix data = first ic=pq;
	class country year ManyJewsMuslims Belgium ;
	model violence0103 = year manyjewsmuslims Belgium Valueslife 
	/ link = log dist = poisson s;
	random country(manyjewsmuslims)/solution;
	random _residual_ /s;
	Covtest 'zerog = no G-side' zerog / cl Wald estimates;
run; 

	/* Except for the Deviance and Scaled Deviance, the above code replicates Table 8.10
		and Figure 8.2*/

	/*The following example using the GLMM Macro replicates Model 5, probably the best model*/
	 /*This code calls the GLMM Macro the source will not be printed*/

%inc 'c:\Program Files\glmm800.sas'/nosource;
run;

%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 5';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium PAProPeace/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;

data bob1; set BOB;
	proc print; 
run;


 /*This code calls the GLMM Macro the source will not be printed, Model 8*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;

%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 8';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium ValuesJewishLife/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;

data bob1; set BOB;
	proc print; 
run;




 /*This code calls the GLMM Macro the source will not be printed, Model 9*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;

%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 9';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium ValuesLife/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;

data bob1; set BOB;
proc print; 
run;

	/* This syntax is now complete */
	/* The syntax in this file is copyright by Robert B. Smith  2011 */

























